package cs3500.lab2.offers;

import java.util.List;
import java.util.Objects;

import cs3500.lab2.skills.Skill;

public class Volunteer implements Offer {

  public final String jobDescription;
  private final List<Skill> requirements;

  public Volunteer(String description, List<Skill> reqs) {
    this.jobDescription = Objects.requireNonNull(description);
    this.requirements = Objects.requireNonNull(reqs);
  }

  @Override
  public int calculateSalary() {
    return 0;
  }

  @Override
  public boolean satisfiesRequirements(List<Skill> application) {
    for(Skill req : requirements) {
      if(!application.stream().anyMatch((appSkill) -> appSkill.satisfiesReq(req))) {
        return false;
      }
    }
    return true;
  }
}
