package cs3500.lab2.offers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import cs3500.lab2.skills.Skill;

public class FullTimeJob implements Offer {

  private String jobDescription;
  private int yearlySalary;
  public final List<Skill> requirements;

  public FullTimeJob(String description, int yearlySalary, List<Skill> reqs) {
    this.jobDescription = Objects.requireNonNull(description);
    this.requirements = Objects.requireNonNull(reqs);
    if(yearlySalary < 0) {
      throw new IllegalArgumentException("Salary cannot be negative");
    }
    this.yearlySalary = yearlySalary;
  }

  @Override
  public int calculateSalary() {
    return this.yearlySalary;
  }

  @Override
  public boolean satisfiesRequirements(List<Skill> application) {
    for(Skill req : requirements) {
      if(!application.stream().anyMatch((appSkill) -> appSkill.satisfiesReq(req))) {
        return false;
      }
    }
    return true;
  }
}
