package cs3500.lab2.offers;

import java.util.List;
import java.util.Objects;

import cs3500.lab2.skills.Skill;

public class Coop implements Offer {

  private final String jobDescription;
  private final int hourlyRate;
  private final int maxHours;
  private final List<Skill> requirements;

  public Coop(String description, int rate, int hours, List<Skill> reqs) {
    this.jobDescription = Objects.requireNonNull(description);
    this.requirements = Objects.requireNonNull(reqs);
    if(rate < 0) {
      throw new IllegalArgumentException("Hourly rate cannot be negative.");
    }
    if(hours < 0) {
      throw new IllegalArgumentException("Max hours cannot be negative");
    }
    this.hourlyRate = rate;
    this.maxHours = hours;
  }

  @Override
  public int calculateSalary() {
    return this.hourlyRate * this.maxHours * 52;
  }

  @Override
  public boolean satisfiesRequirements(List<Skill> application) {
    for(Skill req : requirements) {
      if(!application.stream().anyMatch((appSkill) -> appSkill.satisfiesReq(req))) {
        return false;
      }
    }
    return true;
  }
}
