/* Simple Mini-ML grammar, version 2 */
%{
  open Ast
  open Printf
%}

/* Ocamlyacc Declarations */
%token LPAREN RPAREN LET IN EQ EOF PLUS MINUS TIMES DIV SEMI
%token <int> INT
%token <string> VAR

%start prog

%type <Ast.exp> prog
%type <Ast.exp> exp bexp 


/* Grammar follows */
%%
prog:     exp SEMI SEMI EOF     { $1 }
;

exp:      cexp                  { $1 }
        | LET VAR EQ exp IN exp { Let($2,$4,$6) }
;

cexp:     bexp                  { $1 }
        | bexp PLUS cexp        { Binop($1,Plus,$3) }
        | bexp MINUS cexp       { Binop($1,Minus,$3) }
;

bexp:     aexp                  { $1 }
        | aexp TIMES bexp       { Binop($1,Times,$3) }
        | aexp DIV bexp         { Binop($1,Div,$3) }
;

aexp:	  INT			{ Int($1) }
        | VAR                   { Var($1) }
	| LPAREN exp RPAREN	{ $2 }
;


%%
