/* Simple Mini-ML grammar */
%{
  open Ast
  open Printf
%}

/* Ocamlyacc Declarations */
%token LPAREN RPAREN LET IN EQ EOF PLUS MINUS TIMES DIV SEMI
%token <int> INT
%token <string> VAR

/* Try commenting out the following 2 lines; you'll get some shift-reduce errors */
/* To eliminate those shift-reduce errors, either use following or change your 
   grammar as in parse2.mly */ 
%left PLUS MINUS
%left TIMES DIV

%start prog

%type <Ast.exp> prog
%type <Ast.exp> exp bexp


/* Grammar follows */
%%
prog:     exp SEMI SEMI EOF     { $1 }
;

exp:      bexp                  { $1 }
        | LET VAR EQ exp IN exp { Let($2,$4,$6) } 
;

bexp:	  INT			{ Int($1) }
        | VAR                   { Var($1) }
	| LPAREN exp RPAREN	{ $2 }
	| bexp PLUS bexp	{ Binop($1,Plus,$3) }
	| bexp MINUS bexp	{ Binop($1,Minus,$3) }
	| bexp TIMES bexp	{ Binop($1,Times,$3) }
	| bexp DIV bexp		{ Binop($1,Div,$3) }
;

%%
