type var = string

type binop = Plus | Times | Minus | Div

type exp = 
  Int of int | Var of var | Binop of exp * binop * exp | Let of var * exp * exp
  | If of exp * exp * exp 

let string_of_binop(b:binop) : string = 
  match b with 
    | Plus -> "+"
    | Minus -> "-"
    | Times -> "*"
    | Div -> "/"

let rec string_of_exp (e:exp) : string = 
  match e with 
    | Int i -> string_of_int i 
    | Var x -> x
    | Binop(e1,b,e2) -> 
        Printf.sprintf "(%s %s %s)" (string_of_exp e1) (string_of_binop b) (string_of_exp e2) 
    | Let(x,e1,e2) -> Printf.sprintf "(let %s = %s in %s)" x (string_of_exp e1) (string_of_exp e2)
    | If(e1,e2,e3) -> Printf.sprintf "(if %s then %s else %s)" (string_of_exp e1) (string_of_exp e2) (string_of_exp e3)
