/*
 * Testbed.h - A Testing Program for MPLib.prc
 *
 * This code is in the public domain. I would appreciate bug reports and
 * enhancements.
 *
 * Duncan S Wong  <swong@ieee.org>
 *
 * Dec 15, 2000 - Initial Version
 */

// Testbed Version 1.0 (Dec 15, 2000) - Initial Version

#ifndef __TESTBED_H__
#define __TESTBED_H__

#ifdef ERROR_CHECK_LEVEL
#undef ERROR_CHECK_LEVEL
#endif
#define ERROR_CHECK_LEVEL ERROR_CHECK_FULL


// Define the minimum OS version we support
#define ourMinVersion sysMakeROMVersion(2,0,0,sysROMStageRelease,0)

// shared library reference numbers
//static UInt16 MPLibRefNum;           // MPLib shared library reference number
//static UInt16 MDLibRefNum;           // MDLib shared library reference number
//static UInt16 SHALibRefNum;          // SHALib shared library reference number
//static UInt16 SSC2LibRefNum;         // SSC2Lib shared library reference number
static UInt16 RijndaelLibRefNum;     // RijndaelLib shared library reference number

// Buffers for multiple precision integer operations
// Their required memory chunks are allocated in StartApplication.
// Then they will be used through the whole application. They will
// be deallocated in StopApplication. In this way, we save the CPU
// time from allocating and deallocating those temp variables in
// our program since they are used frequently.
//static MP_CTX *ctx = NULL;


/***********************************************************************
 * Prototypes
 **********************************************************************/
static Err StartApplication(void);
static Err StopApplication(void);				// clean up before app exit
static Boolean TestbedFormHandleEvent(EventPtr event);
static Boolean ApplicationHandleEvent(EventPtr event);
static void EventLoop(void);

#endif
