/*
 * Testbed.c
 *
 * This code is in the public domain. I would appreciate bug reports and
 * enhancements.
 *
 * Duncan S Wong  <swong@ieee.org>
 *
 * Dec 15, 2000 - Initial Version
 */

// Because we play with #defines that you're not normally expected to play with,
// we tend to run into cryptic link errors by including precompiled headers:
#ifndef PILOT_PRECOMPILED_HEADERS_OFF
	#define	PILOT_PRECOMPILED_HEADERS_OFF
#endif

#include <PalmOS.h>
//#include "MPLib.h"       // Multiple-precision integer arithmetic library header
//#include "MDLib.h"       // Ron Rivest's Message-Digest Algorithms
//#include "SHALib.h"      // SHA library
//#include "SSC2Lib.h"     // SSC2 library
#include "RijndaelLib.h" // Rijndael library
#include "TestbedRsc.h"  // application resource defines
#include "utils.h"
#include "testbed.h"


/***********************************************************************
 *
 * FUNCTION:     StartApplication
 *
 * DESCRIPTION:  This routine sets up the initial state of the application.
 *               It opens the application's database and sets up global variables. 
 *
 * PARAMETERS:   None.
 *
 * RETURNED:     nothing.
 *
 ***********************************************************************/
static Err StartApplication(void)
{
Err      err;         // common.h: typedef short Err

/*
	// load (if needed) and open MPLib
	err = SysLibFind("MPLib", &MPLibRefNum);
	if (err) err = SysLibLoad('libr', 'DWMP', &MPLibRefNum);
	ErrFatalDisplayIf(err, "Cannot load MP Library");
	err = MPLibOpen(MPLibRefNum);
*/

/*	
	// load (if needed) and open MDLib
	err = SysLibFind("MDLib", &MDLibRefNum);
	if (err) err = SysLibLoad('libr', 'DWMD', &MDLibRefNum);
	ErrFatalDisplayIf(err, "Cannot load MD Library");
	err = MDLibOpen(MDLibRefNum);
*/
/*
	// load (if needed) and open SHALib
	err = SysLibFind("SHALib", &SHALibRefNum);
	if (err) err = SysLibLoad('libr', 'WSHA', &SHALibRefNum);
	ErrFatalDisplayIf(err, "Cannot load SHA Library");
	err = SHALibOpen(SHALibRefNum);
*/
/*
	// load (if needed) and open SSC2Lib
	err = SysLibFind("SSC2Lib", &SSC2LibRefNum);
	if (err) err = SysLibLoad('libr', 'HHSL', &SSC2LibRefNum);
	ErrFatalDisplayIf(err, "Cannot load SSC2 Library");
	err = SSC2Open(SSC2LibRefNum);
*/
	// load (if needed) and open RijndaelLib
	err = SysLibFind("RijndaelLib", &RijndaelLibRefNum);
	if (err) err = SysLibLoad('libr', 'DWRL', &RijndaelLibRefNum);
	ErrFatalDisplayIf(err, "Cannot load Rijndael Library");
	err = RijndaelLibOpen(RijndaelLibRefNum);
/*
	// Their required memory chunks are allocated here. Then they will
	// be used through the whole application. They will be deallocated in
	// StopApplication. In this way, we save the CPU time from allocating
  // and deallocating those temp variables in our program as they are
  // used frequently.
	ctx = MPLibMP_CTX_new(MPLibRefNum);
	ErrFatalDisplayIf(ctx == NULL, "Memory allocation error in StartApplication.");
*/
	return 0;
}


/***********************************************************************
 *
 * FUNCTION:    StopApplication
 *
 * DESCRIPTION: This routine closes the application's database.
 *
 * PARAMETERS:  nothing
 *
 * RETURNED:    nothing
 *
 ***********************************************************************/
static Err StopApplication(void)
{
Err error = 0;
UInt32 numapps;

/*
	// deallocate temp buffers
	MPLibMP_CTX_free(MPLibRefNum, ctx);

	// close MPLib and unload if no one's using it
	error = MPLibClose(MPLibRefNum, &numapps);  // check for erros in the Close() routine
	if (numapps == 0)
		SysLibRemove(MPLibRefNum);
*/
/*
	// close MDLib and unload if no one's using it
	error = MDLibClose(MDLibRefNum, &numapps);  // check for erros in the Close() routine
	if (numapps == 0)
		SysLibRemove(MDLibRefNum);
*/
/*
	// close SHALib and unload if no one's using it
	error = SHALibClose(SHALibRefNum, &numapps);  // check for erros in the Close() routine
	if (numapps == 0)
		SysLibRemove(SHALibRefNum);
*/
/*
	// close SSC2Lib and unload if no one's using it
	error = SSC2Close(SSC2LibRefNum, &numapps);  // check for erros in the Close() routine
	if (numapps == 0)
		SysLibRemove(SSC2LibRefNum);
*/
	// close RijndaelLib and unload if no one's using it
	error = RijndaelLibClose(RijndaelLibRefNum, &numapps);  // check for erros in the Close() routine
	if (numapps == 0)
		SysLibRemove(RijndaelLibRefNum);

	FrmCloseAllForms (); // send a frmCloseEvent to all open form event handlers

	return error;
}


/***********************************************************************
 *
 * FUNCTION:		TestbedFormHandleEvent
 *
 * DESCRIPTION:	Handles processing of events for the Wallet form.
 *
 * PARAMETERS:	event	- the most recent event.
 *
 * RETURNED:		True if the event is handled, false otherwise.
 *
 ***********************************************************************/
static Boolean TestbedFormHandleEvent(EventPtr event)
{
Boolean handled = false;
FormPtr frm;
Char *strP = NULL;

	switch (event->eType) {
   	case ctlSelectEvent:  // A control button was pressed and released.
	   	switch (event->data.ctlEnter.controlID) {
				case TestbedComputeButton:


/*
{  // MPLib testing block
INT *a=NULL, *b=NULL, *c=NULL, *d=NULL;
//UInt8 *binINT = NULL;
UInt32 tick_s, tick_t;
//Int16 i;

  // MPLib test setup
  //c = MPLibMP_new(MPLibRefNum);
  //if(a != NULL) MPLibMP_clear_free(MPLibRefNum, a);
  //if(b != NULL) MPLibMP_clear_free(MPLibRefNum, b);
  //if(d != NULL) MPLibMP_clear_free(MPLibRefNum, d);  
  //a = MPLibMP_ascii2bn(MPLibRefNum, "818b96d5454593ee88a33dd971176642ae75ebc6180a0d7829b55e9916162dd6ab001b611ea50e9bec7492c7109a917067a040486dc88c359c8b45ef4b5153dc");
  //b = MPLibMP_ascii2bn(MPLibRefNum, "d18b96d5454596ee88a33dd9a1176642ae757bc6180a0d7839b55e9916c62dd6ab021b611ea50e9bee7492c71092917067a0d0486dc88c35dc8b45ef4b5553db");
  //d = MPLibMP_ascii2bn(MPLibRefNum, "3");
  a = MPLibMP_ascii2bn(MPLibRefNum, "e106cdd008c9150914938a8ca5d784b856154238b7e78e89cbd6569f597620107f5e6ee1c3ea314190e08e24475eb816f1211ed149ff9533e560de4caeaef735");
  b = MPLibMP_ascii2bn(MPLibRefNum, "d18b96d5454596ee88a33dd9a1176642ae757bc6180a0d7839b55e9916c62dd6ab021b611ea50e9bee7492c71092917067a0d0486dc88c35dc8b45ef4b5553db");
  c = MPLibMP_ascii2bn(MPLibRefNum, "818b96d5454593ee88a33dd971176642ae75ebc6180a0d7829b55e9916162dd6ab001b611ea50e9bec7492c7109a917067a040486dc88c359c8b45ef4b5153dc");
  d = MPLibMP_ascii2bn(MPLibRefNum, "b831414e0b4613922bd35b4b36802bc1e1e81c95a27c958f5382003df646154ca92fc1ce02c3be047a45e9b02a9089b4b90278237c965192a0fcc86bb49bc823");
  
  if(strP != NULL) MemPtrFree(strP);
  strP = MPLibMP_bn2ascii(MPLibRefNum, a);
  SetFieldTextFromStr(TestbedAField, strP);
  if(strP != NULL) MemPtrFree(strP);
  strP = MPLibMP_bn2ascii(MPLibRefNum, b);
  SetFieldTextFromStr(TestbedBField, strP);

  // start testing
 	//i=100;
  tick_s = TimGetTicks();

	//{ // CRT of two moduli
		//INT *x = NULL;
		//x = MPLibMP_new(MPLibRefNum);
		//MPLibMP_crt2(MPLibRefNum, x, c, d, a, b, ctx);
		//MPLibMP_copy(MPLibRefNum, c, x);
		//MPLibMP_clear_free(MPLibRefNum, x);
	//}
	
	//while(i-- > 0) {
		//MPLibMP_mod_mul(MPLibRefNum, c, a, b, d, ctx);
		//MPLibMP_add(MPLibRefNum, c, a, a);
		//if(MPLibMP_ucmp(MPLibRefNum, c, d))
		//	MPLibMP_sub(MPLibRefNum, c, c, d);
	//}
	
	//{ // the modulus has to be odd in order to use Montgomery multiplication
		//MP_MONT_CTX *mont;
	
		//mont = MPLibMP_MONT_CTX_new(MPLibRefNum);
	  //MPLibMP_MONT_CTX_set(MPLibRefNum, mont, b, ctx);
		//MPLibMP_mont_mul(MPLibRefNum, c, a, b, mont, ctx);
		//MPLibMP_mont_exp(MPLibRefNum, c, a, d, mont, ctx);
		//MPLibMP_MONT_CTX_free(MPLibRefNum, mont);
	//}

	//MPLibMP_mod_exp(MPLibRefNum, c, a, d, b, ctx);
	
	//if(c != NULL) MPLibMP_clear_free(MPLibRefNum, c);
	//c = MPLibMP_mod_inverse(MPLibRefNum, b, a, ctx);

	{ // Primality test
		Int16 ret;

		ret = MPLibMP_probab_prime(MPLibRefNum, a, 2, ctx);
		MP_zero(c);
		if(ret) MP_one(c);
		if(ret>=2) MPLibMP_lshift1(MPLibRefNum, c, c);
		if(ret==3) {
			MP_one(b);
			MPLibMP_add(MPLibRefNum, c, c, b);
		}
	}
	
  tick_t = TimGetTicks();
  tick_t -= tick_s;

  if(strP != NULL) MemPtrFree(strP);
  strP = MPLibMP_bn2ascii(MPLibRefNum, c);
  SetFieldTextFromStr(TestbedCField, strP);
  SndPlaySystemSound(sndInfo);

  if(strP != NULL) MemPtrFree(strP);
  strP = (Char *) MemPtrNew(11);
  StrPrintF(strP,"%lu", tick_t);
  SetFieldTextFromStr(TestbedSpeedField, strP);

  // clean up
  MPLibMP_clear_free(MPLibRefNum, a);
  MPLibMP_clear_free(MPLibRefNum, b);
  MPLibMP_clear_free(MPLibRefNum, c);
  MPLibMP_clear_free(MPLibRefNum, d);
  if(strP != NULL) MemPtrFree(strP);			
  //if(binINT != NULL) MemPtrFree(binINT);
}
*/


/*
{  // MDLib and SHALib testing block
Char *m;
unsigned char digest[20];
UInt16 mLen;
//MD5_CTX ctx5;
//MD4_CTX ctx4;
//MD2_CTX ctx2;
SHA1_CTX ctx1;
UInt32 tick_s, tick_t;
UInt32 i;

	m = MemPtrNew(1000);
	//StrPrintF(m,"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq");
	//StrPrintF(m,"abcdefghijklmnopqrstuvwxyz");
	//StrPrintF(m,"message digest");
	//StrPrintF(m,"abc");
	//StrPrintF(m,"");
	//mLen = StrLen(m);
  //SetFieldTextFromStr(TestbedAField, m);

	for(i=0; i<1000; i++)
		m[i] = i & 0xff;
	mLen = 1000;
	
	//MDLibMD5Init(MDLibRefNum, &ctx5);
	SHALibSHA1Init(SHALibRefNum, &ctx1);
	
	tick_s = TimGetTicks();
	
	for(i=0; i<1000; i++)
		//MDLibMD5Update(MDLibRefNum, &ctx5, (unsigned char *) m, mLen);
		SHALibSHA1Update(SHALibRefNum, &ctx1, (unsigned char *) m, mLen);
		
  //MDLibMD5Final(MDLibRefNum, digest, &ctx5);
  SHALibSHA1Final(SHALibRefNum, digest, &ctx1);
    
  //MDLibMD4Init(MDLibRefNum, &ctx4);
	//MDLibMD4Update(MDLibRefNum, &ctx4, (unsigned char *) m, mLen);
  //MDLibMD4Final(MDLibRefNum, digest, &ctx4);
  //MDLibMD2Init(MDLibRefNum, &ctx2);
	//MDLibMD2Update(MDLibRefNum, &ctx2, (unsigned char *) m, mLen);
  //MDLibMD2Final(MDLibRefNum, digest, &ctx2);
  
  tick_t = TimGetTicks();
  tick_t -= tick_s;

	strP = hexdump(digest, 20);
  SetFieldTextFromStr(TestbedCField, strP);
	SndPlaySystemSound(sndInfo);
	if(strP != NULL) MemPtrFree(strP);
	
  strP = (Char *) MemPtrNew(11);
  StrPrintF(strP,"%lu", tick_t);
  SetFieldTextFromStr(TestbedSpeedField, strP);
  MemPtrFree(strP);
  
  MemPtrFree(m);
}
*/

/*
{   // SSC2Lib test block
SSC2_CTX key_ctx;
unsigned char key_str[16];
unsigned char *a = NULL, *b = NULL, *c = NULL;
Int16 i;

	a = (unsigned char *) MemPtrNew(50);
	b = (unsigned char *) MemPtrNew(50);
	c = (unsigned char *) MemPtrNew(50);
	if(strP != NULL) MemPtrFree(strP);
	strP = (Char *) MemPtrNew(151);

	StrPrintF((char *)key_str, "This is a test");
	for(i=0; i<50; i++) a[i] = (i+32)%256;
	
	SSC2MasterKeyGeneration(SSC2LibRefNum, key_str, 14, &key_ctx);
	SSC2Encrypt(SSC2LibRefNum, &key_ctx, a, b, 50);
	SSC2MasterKeyGeneration(SSC2LibRefNum, key_str, 14, &key_ctx);	
	SSC2Decrypt(SSC2LibRefNum, &key_ctx, b, c, 50);
	
	strP = hexdump(a, 50);
  SetFieldTextFromStr(TestbedAField, strP);
	strP = hexdump(b, 50);
  SetFieldTextFromStr(TestbedBField, strP);
	strP = hexdump(c, 50);
  SetFieldTextFromStr(TestbedCField, strP);
  
  MemPtrFree(a);
  MemPtrFree(b);
  MemPtrFree(c);
  MemPtrFree(strP);
}
*/

{  // Rijndael testing block
Char *k=NULL;
UInt8 *m=NULL, *c=NULL;
UInt32 tick_s, tick_t;
RijndaelKeyInstance key;		/* AES keyInstances */
Int16 keyLen;
RijndaelCipherInstance cipher;
char iv[] = "00000000000000000000000000000000";
int i;
		
	k = MemPtrNew(100);
	m = (UInt8 *) MemPtrNew(100);
	c = (UInt8 *) MemPtrNew(100);
	//StrPrintF(k,"000102030405060708090A0B0C0D0E0F");
	//keyLen = 128;
	//StrPrintF(k,"000102030405060708090A0B0C0D0E0F1011121314151617");
	//keyLen = 192;
	StrPrintF(k,"000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");
	keyLen = 256;
  SetFieldTextFromStr(TestbedAField, k);
	for(i=0; i<16; i++)
		m[i] = (i<<4) ^ i;
	if(strP != NULL) MemPtrFree(strP);
	strP = hexdump(m, 16);
  SetFieldTextFromStr(TestbedBField, strP);

	tick_s = TimGetTicks();

	RijndaelLibMakeKey(RijndaelLibRefNum, &key, DIR_ENCRYPT, keyLen, k);
	RijndaelLibCipherInit(RijndaelLibRefNum, &cipher, MODE_ECB, NULL);
	RijndaelLibBlockEncrypt(RijndaelLibRefNum, &cipher, &key, m, keyLen, c);

	//RijndaelLibMakeKey(RijndaelLibRefNum, &key, DIR_DECRYPT, keyLen, k);
	//RijndaelLibCipherInit(RijndaelLibRefNum, &cipher, MODE_ECB, NULL);
	//RijndaelLibBlockDecrypt(RijndaelLibRefNum, &cipher, &key, c, keyLen, m);

  tick_t = TimGetTicks();
  tick_t -= tick_s;

	if(strP != NULL) MemPtrFree(strP);
	strP = hexdump(c, 16);
  SetFieldTextFromStr(TestbedCField, strP);
	SndPlaySystemSound(sndInfo);
	if(strP != NULL) MemPtrFree(strP);
	
  strP = (Char *) MemPtrNew(11);
  StrPrintF(strP,"%lu", tick_t);
  SetFieldTextFromStr(TestbedSpeedField, strP);
  
  MemPtrFree(strP);
  MemPtrFree(k);
  MemPtrFree(m);
  MemPtrFree(c);
}

					handled = true;
					break;
			}
			break;

 		case frmOpenEvent:	// The form was told to open.
  		// Load and initialize the wallet form.
    	frm = FrmGetActiveForm();

    	FrmDrawForm(frm);
			handled = true;
			break;
	}

	return handled;
}


/***********************************************************************
 *
 * FUNCTION:    ApplicationHandleEvent
 *
 * DESCRIPTION: This routine loads a form resource and sets the event
 *							handler for the form.
 *
 * PARAMETERS:  event - a pointer to an EventType structure
 *
 * RETURNED:    True if the event has been handled and should not be
 *							passed to a higher level handler.
 *
 ***********************************************************************/
static Boolean ApplicationHandleEvent(EventPtr event)
{
FormPtr frm;
UInt16  formId;
Boolean handled = false;

	if (event->eType == frmLoadEvent) {
		formId = event->data.frmLoad.formID;
		// Load and initialize the form resource.
		// This function doesn't affect the display (use FrmDrawForm to draw the
		// form) nor make the form active (use FrmSetActiveForm to make it active).
		// Call FrmDeleteForm to release the form memory when the form is used.
		// Or call FrmReturnToForm to free the active form
		frm = FrmInitForm(formId);
		// Set the active form. All input (key and pen) is directed to the active
		// form and all drawing occurs there.
		FrmSetActiveForm(frm);

		// Set the event handler for the form.  The handler of the currently 
		// active form is called by FrmDispatchEvent each time it receives an event.
		switch (formId) {
			case TestbedForm:
				// Register the event handler callback routine for this form.
				FrmSetEventHandler(frm, TestbedFormHandleEvent);
				break;
    }
		handled = true;
	}
	
	return handled;
}


/***********************************************************************
 *
 * FUNCTION:		EventLoop
 *
 * DESCRIPTION:	A simple loop that obtains events from the Event
 *							Manager and passes them on to various applications and
 *							system event handlers before passing them on to
 *							FrmDispatchEvent for default processing.
 *
 * PARAMETERS:	None.
 *
 * RETURNED:		Nothing.
 *
 ***********************************************************************/
static void EventLoop(void)
{
Err       err = 0;
EventType	event;
UInt16    error;

	do {
		EvtGetEvent(&event, evtWaitForever);  // Get the next available event
		
		// Give the system a chance to handle the event.
		if (! SysHandleEvent(&event))
			// Give the menu bar a chance to update and handle the event.	
			if (! MenuHandleEvent(0, &event, &error))
				// Give the application a chance to handle the event.
				if (! ApplicationHandleEvent(&event))
					// Let the form object provide default handling of the event.
					// Dispatch an event to the application's handler for the form.
					FrmDispatchEvent(&event);
	} while (event.eType != appStopEvent);
}


/***********************************************************************
 *
 * FUNCTION:		PilotMain
 *
 * DESCRIPTION:	This function is the equivalent of a main() function
 *							under standard C.  It is called by the Emulator to begin
 *							execution of this application.
 *
 * PARAMETERS:	cmd - command specifying how to launch the application.
 *							cmdPBP - parameter block for the command.
 *							launchFlags - flags used to configure the launch.			
 *
 * RETURNED:		Any applicable error codes.
 *
 ***********************************************************************/
UInt32 PilotMain(UInt16 cmd, MemPtr cmdPBP, UInt16 launchFlags)
{
Err err;		// common.h: typedef short Err
	
	// This app makes use of PalmOS 2.0 features.  It will crash if
	// run on an earlier version of PalmOS.  Detect and warn if this happens,
	// then exit.
	if(err = RomVersionCompatible (ourMinVersion, launchFlags)) return err;

	// This app doesn't support any other launch codes except the Normal Launch Code
	if (cmd != sysAppLaunchCmdNormalLaunch) return sysErrParamErr;
	
	// Initialize the application's global variables and database.
	if((err = StartApplication()) == 0) {
		// Send a frmCloseEvent to the current form; send a frmLoadEvent
		// and a frmOpenEvent to the specified form, that's WalletForm.
		FrmGotoForm(TestbedForm);
		EventLoop();        // Start the event loop
		StopApplication();  // clean up before exiting this application
	}
	
	return err;
}
