/*
 * mp_sub.c
 *
 * This code is in the public domain. I would appreciate bug reports and
 * enhancements.
 *
 * Duncan S Wong  <swong@ieee.org>
 *
 * Dec 14, 2000 - Initial Version
 */
#include <PalmOS.h>
#include "mp.h"
#include "mp_priv.h"


// Set r to a - b.
//
// Return 1 if succeed; otherwise return 0.
//
// Note: r can be a or b.
Int16 MP_sub(INT *r, INT *a, INT *b)
{
Int16 max,i;
Int16 add=0, neg=0;
INT *tmp;

	//  a -  b  -->  a-b
	//  a - -b  -->  a+b
	// -a -  b  -->  -(a+b)
	// -a - -b  -->  b-a
	if (a->neg) {
		if (b->neg) { tmp=a; a=b; b=tmp; }
		else { add=1; neg=1; }
  } else {
		if (b->neg) { add=1; neg=0; }
  }

	if (add) {
		i=(a->top > b->top);
    if (MP_alloc(r,(((i)?a->top:b->top)+1)*DIGIT_BITS) == NULL) return(0);
		if (i) MP_qadd(r,a,b);
		else MP_qadd(r,b,a);
		r->neg=neg;
		return(1);
  }

  // both a and b are +ve and we're going to do (a-b)
	max=(a->top > b->top)?a->top:b->top;
	if (MP_alloc(r,max*DIGIT_BITS) == NULL) return(0);
	if (MP_ucmp(a,b) < 0) {
		MP_qsub(r,b,a);
		r->neg=1;
  } else {
		MP_qsub(r,a,b);
		r->neg=0;
  }
	return(1);
}


// Set r to a - b
// where
// 1) a and b are treated as unsigned --- r->neg would not be updated.
// 2) magnitude of a must be greater or equal to that of b.
// 3) r has enough memory allocated already.
// No validity checking of the above statements in this 'quick' subtraction
// function.
//
// Note: r can be a or b.
void MP_qsub(INT *r, INT *a, INT *b)
{
Int16 max, min;
register DIGIT t1, t2, *ap, *bp, *rp;
Int16 i, c;

	max=a->top;
	min=b->top;
	ap=a->d;
	bp=b->d;
	rp=r->d;

	c=0;
	for (i=0; i<min; i++) {
		t1= *(ap++);
		t2= *(bp++);
		if (c) {
			c = (t1 <= t2);
			t1 = (t1-t2-1);
    } else {
			c = (t1 < t2);
			t1 = (t1-t2);
    }
		*(rp++)=t1&DIGIT_MASK;
  }

	if (c) {
		while (i < max) {
			i++;
			t1= *(ap++);
			t2=(t1-1)&DIGIT_MASK;
			*(rp++)=t2;
			if (t1 > t2) break;
    }
  }

  for(; i<max; i++)
    *(rp++) = *(ap++);

	r->top=max;
	MP_fix_top(r);
}
