/*
 * mp_shift.c
 *
 * This code is in the public domain. I would appreciate bug reports and
 * enhancements.
 *
 * Duncan S Wong <swong@ieee.org>
 *
 * Dec 14, 2000 - Initial Version
 */
#include <PalmOS.h>
#include "mp.h"
#include "mp_priv.h"

// Set r to 2*a.
//
// Note: r can be a.
Int16 MP_lshift1(INT *r, INT *a)
{
register DIGIT *ap,*rp,t,c;
Int16 i;

	if (r != a) {
		r->neg=a->neg;
		if (MP_alloc(r, (a->top+1)*DIGIT_BITS) == NULL) return(0);
		r->top=a->top;
  } else {
		if (MP_alloc(r, (a->top+1)*DIGIT_BITS) == NULL) return(0);
  }
	ap=a->d;
	rp=r->d;
	c=0;
	for (i=0; i<a->top; i++) {
		t= *(ap++);
		*(rp++)=((t<<1)|c)&DIGIT_MASK;
		c=(t & DIGIT_HBIT)?1:0;
  }
	if (c) {
		*rp=1;
		r->top++;
  }
	return(1);
}


// Set r to lower ceiling of a/2.
//
// Note : r can be a.
Int16 MP_rshift1(INT *r, INT *a)
{
DIGIT *ap,*rp,t,c;
Int16 i;

	if (MP_is_zero(a)) {
    r->top = 0;
    r->d[0] = 0;
		return(1);
  }
	if (a != r) {
		if (MP_alloc(r, a->top*DIGIT_BITS) == NULL) return(0);
		r->top=a->top;
		r->neg=a->neg;
  }
	ap=a->d;
	rp=r->d;
	c=0;
	for (i=a->top-1; i>=0; i--) {
		t=ap[i];
		rp[i]=((t>>1)&DIGIT_MASK)|c;
		c=(t&1)?DIGIT_HBIT:0;
		}
	MP_fix_top(r);
	return(1);
}


// Shift (INT *)from n bits to the left and put the result to (INT *)to.
//
// Note: - (INT *)from and (INT *)to can be overlapped if n is +ve and
//         from <= to; otherwise, from >= to.
Int16 MP_lshift(INT *to, INT *from, Int16 n)
{
Int16 i,num_digit, lb, rb;
DIGIT *t,*f;
DIGIT l;

	to->neg = from->neg;
	if (MP_alloc(to, (from->top*DIGIT_BITS)+n) == NULL) return(0);
	num_digit = n/DIGIT_BITS;
	lb = n%DIGIT_BITS;
	rb = DIGIT_BITS-lb;
	f = from->d;
	t = to->d;
	t[from->top+num_digit] = 0;
	if (lb == 0)
		for (i=from->top-1; i>=0; i--)
			t[num_digit+i] = f[i];
	else
		for (i=from->top-1; i>=0; i--) {
			l = f[i];
			t[num_digit+i+1]|=(l>>rb)&DIGIT_MASK;
			t[num_digit+i]=(l<<lb)&DIGIT_MASK;
    }
	memset(t, 0, num_digit*sizeof(DIGIT));

	to->top = from->top + num_digit + 1;
	MP_fix_top(to);
	return(1);
}


// Shift (INT *)from n bits to the right and put the result to (INT *)to.
//
// Note: (INT *)from and (INT *)to can be overlapped if (to-from)<n for +ve n.
Int16 MP_rshift(INT *to, INT *from, Int16 n)
{
Int16 i,j,nd,lb,rb;
DIGIT *t,*f;
DIGIT l,tmp;

	nd=n/DIGIT_BITS;
	rb=n%DIGIT_BITS;
	lb=DIGIT_BITS-rb;
	if (nd > from->top) {
    to->top = 0;
		return(1);
  }
	if (to != from) {
		to->neg = from->neg;
		if (MP_alloc(to, (from->top-nd+1)*DIGIT_BITS) == NULL) return(0);
  }

	f= &(from->d[nd]);
	t= to->d;
	j= from->top-nd;
	to->top=j;

	if (rb == 0) {
		for (i=j+1; i > 0; i--)
			*(t++)= *(f++);
  } else {
		l= *(f++);
		for (i=1; i<j; i++) {
			tmp =(l>>rb)&DIGIT_MASK;
			l= *(f++);
			*(t++) =(tmp|(l<<lb))&DIGIT_MASK;
    }
		*(t++) =(l>>rb)&DIGIT_MASK;
  }
	*t=0;
	MP_fix_top(to);
	return(1);
}
