/*
 * mp_priv.h
 *
 * This code is in the public domain. I would appreciate bug reports and
 * enhancements.
 *
 * Duncan S Wong <swong@ieee.org>
 *
 * Dec 14, 2000 - Initial Version
 */
#ifndef __MP_PRIV_H__
#define __MP_PRIV_H__

#include "mp.h"

// Macros
#define MP_alloc(n,b)  ((((b)/DIGIT_BITS) <= (n)->max)?(n):MP_expand((n),(b)))
#define Realloc(a,n)   PalmOS_realloc(a,n)     // in mp_lib.c
#define MP_fix_top(a) \
	{ \
	DIGIT *fix_top_l; \
	for (fix_top_l= &((a)->d[(a)->top-1]); (a)->top > 0; (a)->top--) \
		if (*(fix_top_l--)) break; \
	}
#define MP_num_bytes(a)	((MP_num_bits(a)+7)/8)

#define Ldigit(t)    (((DIGIT)(t))&DIGIT_MASK)
#define Hdigit(t)    (((DIGIT)((t)>>DIGIT_BITS))&DIGIT_MASK)
#define LBITS(a)     ((a)&DIGIT_MASKl)
#define HBITS(a)     (((a)>>DIGIT_BITSl)&DIGIT_MASKl)
#define	HBITSl(a)    ((DIGIT)((a)&DIGIT_MASKl)<<DIGIT_BITSl)

//#ifdef DIGIT
#define mul(r,a,w,c) { \
	DOUBLE_DIGIT t; \
	t=(DOUBLE_DIGIT)(w) * (a) + (c); \
	(r) = Ldigit(t); \
	(c) = Hdigit(t); \
	}

#define mul_add(r,a,w,c) { \
	DOUBLE_DIGIT t; \
	t=(DOUBLE_DIGIT)(w) * (a) + (r) + (c); \
	(r) = Ldigit(t); \
	(c) = Hdigit(t); \
	}

// (cr) = r + 2a*w + c where c is DOUBLE_DIGIT.
#if defined(EIGHT_BIT) || defined(SIXTEEN_BIT)
// applied only for EIGHT_BIT or SIXTEEN_BIT
#define mul_add_double(r,a,w,c) { \
  TETRA_DIGIT t; \
  t = (TETRA_DIGIT)(a) * (w) * 2  + (r) + (c); \
  (r) = Ldigit(t); \
  (c) = ((DOUBLE_DIGIT)(t>>DIGIT_BITS))&DOUBLE_DIGIT_MASK; \
	}
#else
#define mul_add_double(r,a,w,c) { \
	DOUBLE_DIGIT t; \
  DIGIT inner_c; \
  t = (DOUBLE_DIGIT)(a) * (w); \
  inner_c = (t & DOUBLE_DIGIT_HBIT) ? 1 : 0; \
  t = (t << 1) + (r) + (c); \
  inner_c += (t < c); \
	(r) = Ldigit(t); \
	(c) = (DOUBLE_DIGIT)Hdigit(t) | (((DOUBLE_DIGIT)inner_c)<<DIGIT_BITS); \
	}
#endif

#define mul64(l,h,bl,bh) { \
	DIGIT m,m1,lt,ht; \
	lt=l; \
	ht=h; \
	m =(bh)*(lt); \
	lt=(bl)*(lt); \
	m1=(bl)*(ht); \
	ht =(bh)*(ht); \
	m+=m1; if ((m&DIGIT_MASK) < m1) ht+=HBITSl(1L); \
	ht+=HBITS(m); \
	m1=HBITSl(m); \
	lt+=m1; if ((lt&DIGIT_MASK) < m1) ht++; \
	(l)=lt; \
	(h)=ht; \
	}


// Prototypes
// mp_lib.c
void *memset(void *b, UInt8 c, Int32 len);
void *memcpy(void *dst, void *src, Int32 len);
void *PalmOS_realloc(void *ptr, UInt32 size);
INT *MP_expand(INT *b, UInt32 bits);

// mp_div.c
DIGIT MP_div2(DIGIT h, DIGIT l, DIGIT d);

#endif
