/*
 * mp_cmp.c
 *
 * This code is in the public domain. I would appreciate bug reports and
 * enhancements.
 *
 * Duncan S Wong <swong@ieee.org>
 *
 * Dec 14, 2000 - Initial Version
 */
#include <PalmOS.h>
#include "mp.h"
#include "mp_priv.h"

// Compare a and b
// Return 1 if a > b, 0 if a = b and -1 if a < b
Int16 MP_cmp(INT *a, INT *b)
{
Int16 i, gt, lt;
DIGIT t1,t2;

	if ((a == NULL) || (b == NULL)) {
		if (a != NULL) return(-1);
		else if (b != NULL) return(1);
		else return(0);
  }

	if (a->neg != b->neg) {
		if (a->neg) return(-1);
		else	return(1);
  }

	if (a->neg == 0) { gt=1; lt= -1; }
	else	{ gt= -1; lt=1; }

	if (a->top > b->top) return(gt);
	if (a->top < b->top) return(lt);
	for (i=a->top-1; i>=0; i--) {
		t1=a->d[i];
		t2=b->d[i];
		if (t1 > t2) return(gt);
		if (t1 < t2) return(lt);
  }
	return(0);
}


// Compare a and b as 'unsigned' integers.
// Return a positive value if a > b, zero if a = b,
// and a negative value if a < b.
Int16 MP_ucmp(INT *a, INT *b)
{
Int16 i;
DIGIT t1,t2,*ap,*bp;

	i=a->top - b->top;
	if (i != 0) return(i);
	ap=a->d;
	bp=b->d;
	for (i=a->top-1; i>=0; i--) {
		t1= ap[i];
		t2= bp[i];
		if (t1 != t2)
			return(t1 > t2?1:-1);
  }
	return(0);
}


// Return 1 if the n bit of (INT *) a is set (n starts at 0).
Int16 MP_is_bit_set(INT *a, Int16 n)
{
Int16 i,j;

	if (n < 0) return(0);
	i = n/DIGIT_BITS;
	j = n%DIGIT_BITS;
	if (a->top <= i) return(0);
	return((a->d[i]&(((DIGIT)1)<<j))?1:0);
}
