/*
 * mp_add.c
 *
 * This code is in the public domain. I would appreciate bug reports and
 * enhancements.
 *
 * Duncan S Wong  <swong@ieee.org>
 *
 * Dec 14, 2000 - Initial Version
 */
#include <PalmOS.h>
#include "mp.h"
#include "mp_priv.h"

// Set s to a + b.
//
// Return 1 if succeed; otherwise return 0.
//
// Note: s can be a or b
Int16 MP_add(INT *s, INT *a, INT *b)
{
Int16 i;
INT *tmp;

  // 4 cases
	//  a +  b  -->  a+b
	//  a + -b  -->  a-b
	// -a +  b  -->  b-a
	// -a + -b  -->  -(a+b)
  if (a->neg ^ b->neg) { // only one is negative
    if (a->neg) { tmp=a; a=b; b=tmp; }

		// +ve a and -ve b
    if (MP_alloc(s,((a->top > b->top)?a->top:b->top)*DIGIT_BITS) == NULL) {
      ErrDisplay("Memory allocation error in MP_add. (1)");
      return(0);
    }

		if (MP_ucmp(a,b) < 0) {
			MP_qsub(s,b,a);
			s->neg=1;
    } else {
			MP_qsub(s,a,b);
			s->neg=0;
    }
    return(1);
  }

  // same sign
	if (a->neg) s->neg=1;
	else        s->neg=0;

	i=(a->top > b->top);
	if (MP_alloc(s,(((i)?a->top:b->top)+1)*DIGIT_BITS) == NULL) {
    ErrDisplay("Memory allocation error in MP_add. (2)");
    return(0);
  }

	if (i) MP_qadd(s,a,b);
	else   MP_qadd(s,b,a);

	return(1);
}


// Set s to a + b   (quick addition)
// where
// 1) a and b are treated as unsigned, i.e. s->neg would not be updated
// 2) |a| is great than or equal to |b|
// 3) s has enough memory allocated already
// This function does not check the validity of the inputs for speed
//
// Note: s can be a or b
void MP_qadd(INT *s, INT *a, INT *b)
{
register Int16 i;
Int16 max,min;
DIGIT *ap, *bp, *sp;
DIGIT c, t1, t2;

	max = a->top;
	min = b->top;
	s->top = max;

	ap = a->d;
	bp = b->d;
	sp = s->d;
	c = 0;
	for (i=0; i<min; i++) {
		t1 = *(ap++);
		t2 = *(bp++);
		if (c) {
			c = (t2 >= ((~t1)&DIGIT_MASK));
			t2 = (t1+t2+1)&DIGIT_MASK;
		} else {
			t2 = (t1+t2)&DIGIT_MASK;
			c = (t2 < t1);
		}
  	*(sp++) = t2;
	}

	if (c) {
		while (i < max) {
			t1 = *(ap++);
			t2 = (t1+1)&DIGIT_MASK;
			*(sp++) = t2;
			c = (t2 < t1);
			i++;
			if (!c) break;
		}
		if ((i >= max) && c) {
			*(sp++)=1;
			s->top++;
		}
	}

	for (; i<max; i++)
		*(sp++)= *(ap++);
}
