/*
 * MPLibPrv.h
 *
 * Note: - Prv stands for PRIVATE
 *
 * This code is in the public domain. I would appreciate bug reports and
 * enhancements.
 *
 * Duncan S Wong <swong@ieee.org>
 *
 * Dec 14, 2000 - Major Modification
 * Sep  8, 2000 - Initial Version
 */

// *****
// * AUTHOR:		Jeff Ishaq 05/21/99
// * 
// * DESCRIPTION:	Shared library functionality interface definition for PRIVATE
// * functions. These should be used to build a library, but should not be
// * distributed with that library; instead, just distribute MPLib.h
// *
// * COPYRIGHT:		As long as this 'copyright' is intact, this code is freely modifiable
// *				and distributable.
// *****

#ifndef __MPLIBPRV_H__
#define __MPLIBPRV_H__

// This is the Globals struct that we use throughout our library.
typedef struct tagGlobalsType
{
Int16 iOpenCount;          // Our internal open-count of the lib
	
	// Your globals go here...
} GlobalsType;
typedef GlobalsType* GlobalsTypePtr;

// These are some utility functions.
// We don't actually use these in our dispatch table,
// so we don't need to define traps for them nor extern them.
GlobalsTypePtr AllocGlobals	(UInt16 uRefNum);
GlobalsTypePtr LockGlobals	(UInt16 uRefNum);
Err FreeGlobals	(UInt16 uRefNum);
Err UnlockGlobals(GlobalsTypePtr gP);

#endif
