/*
 * MPLibDispatch.c
 *
 * This code is in the public domain. I would appreciate bug reports and
 * enhancements.
 *
 * Duncan S Wong <swong@ieee.org>
 *
 * Feb 11, 2001 - v0.2
 * Sep  8, 2000 - Initial Implementation
 */

// *****
// * DESCRIPTION:	Installation routine for shared library's dispatch table.
// *
// * COPYRIGHT:		As long as this 'copyright' is intact, this code is freely modifiable
// *				and distributable.
// *****

// Because we play with #defines that you're not normally expected to play with,
// we tend to run into cryptic link errors by including precompiled headers:
#ifndef PILOT_PRECOMPILED_HEADERS_OFF
	#define	PILOT_PRECOMPILED_HEADERS_OFF
#endif

#define EMULATION_LEVEL		EMULATION_NONE		// Force this to no emulation:

#undef 		__PALMOS_TRAPS__					// To prevent a redeclaration error
#define 	__PALMOS_TRAPS__ 	0				// Now, define this ourselves
#define		USE_TRAPS 			0				// To _make_ traps, we need to turn this off

#include <PalmOS.h>     // OS 3.5, previously Pilot.h
#include "MPLib.h"

Err __Startup__(UInt16 uRefNum, SysLibTblEntryPtr entryP);
static MemPtr	asm DispatchTable(void);

// *****
// * FUNCTION: 		__Startup__
// * 
// * DESCRIPTION:	Called to install the library by SysLibLoad().  You mustn't change
// *				the function's signature.
// *
// * PARAMETERS:	uRefNum	-	Lib refnum
// *	      			entryP	-	Ptr to our entry in the OS's lib table
// *
// * RETURNS:	    Always 0.  I don't know why uses this return value, or if it's needed.
// *			
// *	JeffI	05/19/99	Initial Implementation
// *****
Err __Startup__(UInt16 uRefNum, SysLibTblEntryPtr entryP)
{
	// Stash our dispatch table's address into the OS's shared libaray
	// table ptr slot that corresponds to this uRefNum:
	entryP->dispatchTblP = (MemPtr*) DispatchTable();
	
	// Zero the globals ptr so that our call to MSLAllocGlobals() does the
	// right thing:
	entryP->globalsP = 0;

	return 0;
}

#define prvJmpSize          4     // How many bytes a JMP instruction occupies
#define NUMBER_OF_FUNCTIONS 46    // Don't forget to update this if necessary!!

#define TABLE_OFFSET        2 * (NUMBER_OF_FUNCTIONS + 1)

#define DISPATCH_SLOT(i)    (TABLE_OFFSET + ( (i) * prvJmpSize))

// *****
// * FUNCTION: 		DispatchTable
// * 
// * DESCRIPTION:	The actual dispatch table. The linker will run through
// * here and put the addresses of the JMP'd-to functions.
// *
// * RETURNS:		(MemPtr)This
// *****
static MemPtr	asm	DispatchTable(void)
{
	// - Trap modification checklist -
	// 
	// If you add, remove or otherwise modify something here,
  // be sure you've also done all of the following steps!
	//
	// 0) All trap identifiers must always run sequentially; no gaps!
	// 1) Modify the MPTrapNumEnum in MPLib.h
	// 2) Modify the DC.W to DispatchTable() in MPLibDispatch.c (no gaps!)
	// 3) Modify the JMP in DispatchTable() in MPLibDispatch.c (no gaps!)
	// 4) ** Update NUMBER_OF_FUNCTIONS in MPLibDispatch.c ** (0-based)
	// 5) Add or remove an "extern MyFunc(...) SYS_TRAP(MPTrapMyFunc)" prototype somewhere

	LEA	@TableStart, A0
	RTS
	
@TableStart:
	DC.W		@LibName
	
	DC.W		DISPATCH_SLOT(0)			// MPLibOpen()
	DC.W		DISPATCH_SLOT(1)			// MPLibClose()
	DC.W		DISPATCH_SLOT(2)			// MPLibSleep()
	DC.W		DISPATCH_SLOT(3)			// MPLibWake()
	DC.W		DISPATCH_SLOT(4)
	DC.W		DISPATCH_SLOT(5)
	DC.W		DISPATCH_SLOT(6)
	DC.W		DISPATCH_SLOT(7)
	DC.W		DISPATCH_SLOT(8)
	DC.W		DISPATCH_SLOT(9)
	DC.W		DISPATCH_SLOT(10)
	DC.W		DISPATCH_SLOT(11)
	DC.W		DISPATCH_SLOT(12)
	DC.W		DISPATCH_SLOT(13)
	DC.W		DISPATCH_SLOT(14)
	DC.W		DISPATCH_SLOT(15)
	DC.W		DISPATCH_SLOT(16)
	DC.W		DISPATCH_SLOT(17)
	DC.W		DISPATCH_SLOT(18)
	DC.W		DISPATCH_SLOT(19)
	DC.W		DISPATCH_SLOT(20)
	DC.W		DISPATCH_SLOT(21)
	DC.W		DISPATCH_SLOT(22)
	DC.W		DISPATCH_SLOT(23)
	DC.W		DISPATCH_SLOT(24)
	DC.W		DISPATCH_SLOT(25)
	DC.W		DISPATCH_SLOT(26)
	DC.W		DISPATCH_SLOT(27)
	DC.W		DISPATCH_SLOT(28)
	DC.W		DISPATCH_SLOT(29)
	DC.W		DISPATCH_SLOT(30)
	DC.W		DISPATCH_SLOT(31)
	DC.W		DISPATCH_SLOT(32)
	DC.W		DISPATCH_SLOT(33)
	DC.W		DISPATCH_SLOT(34)
	DC.W		DISPATCH_SLOT(35)
	DC.W		DISPATCH_SLOT(36)
	DC.W		DISPATCH_SLOT(37)
	DC.W		DISPATCH_SLOT(38)
	DC.W		DISPATCH_SLOT(39)
	DC.W		DISPATCH_SLOT(40)
	DC.W		DISPATCH_SLOT(41)
	DC.W		DISPATCH_SLOT(42)
	DC.W		DISPATCH_SLOT(43)
	DC.W		DISPATCH_SLOT(44)
	DC.W		DISPATCH_SLOT(45)

	JMP			MPLibOpen								// 0
	JMP			MPLibClose							// 1
	JMP 		MPLibSleep							// 2
	JMP			MPLibWake								// 3

	JMP			MPLibMP_new
	JMP			MPLibMP_clear
	JMP			MPLibMP_free
	JMP			MPLibMP_clear_free
	JMP			MPLibMP_CTX_new
	JMP			MPLibMP_CTX_free
	JMP			MPLibMP_MONT_CTX_new
	JMP			MPLibMP_MONT_CTX_free
	JMP			MPLibMP_MONT_CTX_set

	JMP			MPLibMP_mask_bits
	JMP			MPLibMP_copy

	JMP			MPLibMP_add
	JMP			MPLibMP_qadd
	JMP			MPLibMP_sub
	JMP			MPLibMP_qsub
	JMP			MPLibMP_mul
	JMP			MPLibMP_mul_digit
	JMP			MPLibMP_mul_add_digit
	JMP			MPLibMP_sqr
	JMP			MPLibMP_div

	JMP			MPLibMP_lshift
	JMP			MPLibMP_lshift1
	JMP			MPLibMP_rshift
	JMP			MPLibMP_rshift1

	JMP			MPLibMP_cmp
	JMP			MPLibMP_ucmp
	JMP			MPLibMP_is_bit_set

	JMP			MPLibMP_mod_mul
	JMP			MPLibMP_mont_mul
	JMP			MPLibMP_mod_inverse
	JMP			MPLibMP_mod_exp
	JMP			MPLibMP_mont_exp
	JMP			MPLibMP_gcd
	JMP			MPLibMP_binary_gcd
	JMP			MPLibMP_crt2
	JMP			MPLibMP_probab_prime

	JMP			MPLibMP_bin2bn
	JMP			MPLibMP_bn2bin
	JMP			MPLibMP_ascii2bn
	JMP			MPLibMP_bn2ascii
	JMP			MPLibMP_num_bits
  JMP     MPLibMP_num_bits_digit

@LibName:
	DC.B		MPLIB_NAME               // SysLibFind()'s name key
}
