%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Selective Subtraction
% Adeel Bhutta
% Created: 02/18/2020
% Updated: 02/20/2020
% Comments: Everything working ok. 
%
% Please cite the following paper:
%
% Adeel A. Bhutta, I. N. Junejo and H. Foroosh, "Selective Subtraction for Handheld Cameras," in IEEE Access.
% DOI: 10.1109/ACCESS.2020.2973655
% &
% Adeel A. Bhutta, I. N. Junejo and H. Foroosh, "Selective subtraction when the scene cannot be learned," 
% 2011 18th IEEE International Conference on Image Processing, Brussels, 2011, pp. 3273-3276.
% DOI: 10.1109/ICIP.2011.6116369
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Suggested Steps: 
% (1) Find Fundamental Matrix, and Epipoles
% (2) Choose Head and Feet positions of start and end of the walk to define a refernce place
% (3) Calculate projective depth (rhos) for any given point or an object wrt reference plane
% (4) Check the sign of rho to figure out if points belong to foreground or background
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear
% Load two views of an image (from two cameras)
LName='D:\Research\LeftCamImage1.jpg';
RName='D:\Research\RightCamImage1.jpg';

% Use SIFT to find point correspondences. Replace with your own sift
% function if needed
display(sprintf('Finding Base Homography'));
[pts1o,pts2o] = multisift(origLImg, origRImg, 1, 0.7);    
pts1oo = [pts1o(2,:);pts1o(1,:);pts1o(3,:)]; 
pts2oo = [pts2o(2,:);pts2o(1,:);pts2o(3,:)];

% Find Fundamental Matrix and two epipoles
[F,ip] = ransacfitfundmatrix(pts1oo,pts2oo,0.01); 
e = hnormalise(null(F)); ep = hnormalise(null(F'));
pts1oc = pts1o(:,ip); pts2oc = pts2o(:,ip);
% You can also use manual Clicking of points to calculate F.

% Using human walk (Top and Bottom points of a start and end of Walk) to 
% define a Homography or refernce plane
H1 = [-0.5278, 0.0000, 41.4550; 0.1193, -0.6141, -47.0795; 0.0003, 0.0000, -0.6805]; %

% Find projective depth - you could choose some connected component and
% then choose to measure the depth for one or all points of that component. 
% Also, get correspondecnce(s)
npts1c = [pts1c(2,:);pts1c(1,:);pts1c(3,:)];
npts2c = [pts2c(2,:);pts2c(1,:);pts2c(3,:)];

%Calculate projective depth or rhos
rhos = [];
for j = 1:size(npts1c,2)
    warning off
    rhos = [rhos ((hnormalise(H1 * npts1c(:,j)) - npts2c(:,j)) ./ (ep - npts2c(:,j)))];
end

% Test to see the sign of projective depth to figure out which points or
% objects belong to forground or background
ptsi_f = find(rhos(1,:)>=0); %forground points
ptsi_b = find(rhos(1,:)<0); %background points
nb_pts1 = npts1c(:,ptsi_b); nf_pts1 = npts1c(:,ptsi_f);
nb_pts2 = npts2c(:,ptsi_b); nf_pts2 = npts2c(:,ptsi_f);
if isempty(nb_pts1) 
    display(sprintf('Found %d pts in front (>0) and %d in the back (<=0)',size(nf_pts1,2),0));
elseif isempty(nf_pts1)
    display(sprintf('Found %d pts in front (>0) and %d in the back (<=0)',0,size(nb_pts1,2)));                
else
    display(sprintf('Found %d pts in front (>0) and %d in the back (<=0)',size(nf_pts1,2),size(nb_pts1,2)));
end