function [pts1,pts2] = multisift(image1, image2, L, distRatio)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Multisift function for Selective Subtraction
% Adeel Bhutta
% Created: 02/18/2020
% Updated: 02/20/2020
% Comments: Everything working ok. 
%
% This function finds sift keypoint for two given images on multiple
% resolutions (i.e., levels) and returns the correspondences found from all
% levels. Notice that the points returned are (row, column) or (y, x) order.
% Also current Version doesn't look for unique points.
%
% Note: L=2 means images will be resize to two levels (1/2 and 1).
%
% Example: [pts1, pts2] = multisift(image1, image2, L, distRatio)
%

pts1r = []; pts2r =[]; 
for i = 1/L:1/L:1
    I1 = imresize(image1,i);
    I2 = imresize(image2,i);
    [im1, des1, loc1] = sift(I1);
    [im2, des2, loc2] = sift(I2);
    if size(des1,1)==0 & size(des2,1)==0
        fprintf('Zero Keypoints.\n');
        pts1 = [];
        pts2 = [];
        return;
    else
        matches = matchdes(des1, des2, distRatio);
    end
    pts1r = [pts1r loc1(matches(1,:),1:2)'];
    pts2r = [pts2r loc2(matches(2,:),1:2)'];    
end

% Finding Unique Points
% pts1r = pts1r'; [pts1, m1, n1] = unique(pts1r, 'rows'); pts1 = pts1';
% pts2r = pts2r'; [pts2, m1, n1] = unique(pts2r, 'rows'); pts2 = pts2';
% pts1 = [pts1;ones(1,size(pts1,2))];
% pts2 = [pts2;ones(1,size(pts2,2))];

pts1 = [pts1r;ones(1,size(pts1r,2))];
pts2 = [pts2r;ones(1,size(pts2r,2))];